/* chunkhash.h -- a perfect hash code for the chunk names in png.h
 *
 * Last changed in libpng 1.7.0 [(PENDING RELEASE)]
 *
 * THIS IS A MACHINE GENERATED FILE.  See contrib/tools/chunkhash.c for
 * copyright and other information.
 *
 * USAGE:  To include the PNG_CHUNK_HASH macro and associated definitions:
 *
 * #define PNG_CHUNKHASH_DEFS
 * #include "contrib/tools/chunkhash.h"
 *
 * To define the png_chunk_hash array used by the macro:
 *
 * #define PNG_CHUNKHASH_CODE
 * #include "contrib/tools/chunkhash.h"
 *
 * One or both of the defines must be given except when building chunkhash
 * itself.
 */
#ifdef PNG_CHUNKHASH_DEFS
#ifndef PNG_CHUNKHASH_H
#define PNG_CHUNKHASH_H
/* A perfect hash code - returns a value 0..(PNG_KNOWN_CHUNK_COUNT-1) and is
 * generated by the ridiculously simple program in contrib/tools/chunkhash.c
 *
 * The hash code used here multiplies each byte by a different constant to
 * return a single number:
 *
 *    b0 * c[0] + b1 * [c1] + b2 * c[2] + b3 * c[3]
 *
 * The values of the constants are found by search using the a table of
 * primes, including 0, and may be (in fact are at present) 0 for some of the
 * bytes, the compiler is expected to optimize multiply by zero, or one!
 *
 * The lookup table reduces the sparse result of the hash calculation to the
 * correct index values.  The chunks are indexed in the string order of the
 * png_uint_32 chunk names.
 */
#define PNG_CHUNK_HASH_MASK 0x3fU
#define PNG_CHUNK_HASH_C0 103
#define PNG_CHUNK_HASH_C1 1
#define PNG_CHUNK_HASH_C2 0
#define PNG_CHUNK_HASH_C3 1

#define PNG_CHUNK_IDAT_TAG 0
#define PNG_CHUNK_IEND_TAG 1
#define PNG_CHUNK_IHDR_TAG 2
#define PNG_CHUNK_PLTE_TAG 3
#define PNG_CHUNK_bKGD_TAG 4
#define PNG_CHUNK_cHRM_TAG 5
#define PNG_CHUNK_fRAc_TAG 6
#define PNG_CHUNK_gAMA_TAG 7
#define PNG_CHUNK_gIFg_TAG 8
#define PNG_CHUNK_gIFt_TAG 9
#define PNG_CHUNK_gIFx_TAG 10
#define PNG_CHUNK_hIST_TAG 11
#define PNG_CHUNK_iCCP_TAG 12
#define PNG_CHUNK_iTXt_TAG 13
#define PNG_CHUNK_oFFs_TAG 14
#define PNG_CHUNK_pCAL_TAG 15
#define PNG_CHUNK_pHYs_TAG 16
#define PNG_CHUNK_sBIT_TAG 17
#define PNG_CHUNK_sCAL_TAG 18
#define PNG_CHUNK_sPLT_TAG 19
#define PNG_CHUNK_sRGB_TAG 20
#define PNG_CHUNK_sTER_TAG 21
#define PNG_CHUNK_tEXt_TAG 22
#define PNG_CHUNK_tIME_TAG 23
#define PNG_CHUNK_tRNS_TAG 24
#define PNG_CHUNK_zTXt_TAG 25

#define PNG_KNOWN_CHUNK_COUNT 26

extern const png_byte png_chunk_hash[PNG_CHUNK_HASH_MASK+1];
#endif /* !PNG_CHUNKHASH_H */
#endif /* PNG_CHUNKHASH_DEFS */

#ifndef PNG_CHUNK_HASH
#define PNG_CHUNK_HASH(chunk) (png_chunk_hash[PNG_CHUNK_HASH_MASK & (\
      ((chunk) >> 24) * PNG_CHUNK_HASH_C0 +\
      ((chunk) >> 16) * PNG_CHUNK_HASH_C1 +\
      ((chunk) >>  8) * PNG_CHUNK_HASH_C2 +\
      ((chunk)      ) * PNG_CHUNK_HASH_C3)])
#endif

#ifdef PNG_CHUNKHASH_CODE
#ifndef PNG_CHUNKHASH_C
#define PNG_CHUNKHASH_C
const png_byte png_chunk_hash[PNG_CHUNK_HASH_MASK+1] = {
   26, 3, 26, 26, 26, 26, 26, 13, 26, 26, 26, 16, 26, 26, 26, 26,
   26, 24, 12, 26, 18, 26, 26, 26, 26, 20, 26, 17, 26, 26, 25, 15,
   26, 8, 14, 26, 26, 22, 26, 26, 1, 19, 5, 21, 26, 26, 9, 26,
   26, 26, 10, 7, 26, 11, 26, 0, 26, 2, 23, 26, 26, 4, 26, 6
};
#endif /* !PNG_CHUNKHASH_C */
#endif /* PNG_CHUNKHASH_CODE */
